//********************************************************************
//  Points.java       Author: Lewis and Loftus
//
//  Solution to Programming Project 5.29 (5E, p. 289)
//********************************************************************

import javax.swing.JApplet;
import java.awt.*;
import java.util.Random;

public class Points extends JApplet
{
   private final int APPLET_WIDTH = 300;
   private final int APPLET_HEIGHT = 200;
   private final int NUM_POINTS = 20000;

   private Random rand = new Random();

   //-----------------------------------------------------------------
   //  Draws many points with those on the left half in red and
   //  those on the right half in green.
   //-----------------------------------------------------------------
   public void paint (Graphics page)
   {
      int x, y;

      setBackground (Color.black);

      for (int count=1; count <= NUM_POINTS; count++)
      {
         x = Math.abs(rand.nextInt()) % APPLET_WIDTH;
         y = Math.abs(rand.nextInt()) % APPLET_HEIGHT;

         if (x < APPLET_WIDTH/2)
            page.setColor (Color.red);
         else
            page.setColor (Color.green);

         page.drawLine (x, y, x, y);
      }
   }
}
